package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhuenhui
 * @date 2022/12/13 20:33
 * @description 商城 - 虚拟商品兑换信息
 */
@Data
public class MallOrderVirtualExchangeInfoDto implements Serializable {

    private static final long serialVersionUID = 2521200556285020631L;

    /**
     * 兑换类型 1-兑换码 2-兑换链接 3-卡号卡密
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.goods.VirtualExchangeTypeEnum}
     */
    private Integer exchangeType;

    /**
     * 有效期
     */
    private Date expireDate;

    /**
     * 兑换码
     */
    private String exchangeCode;

    /**
     * 兑换链接
     */
    private String exchangeUrl;

    /**
     * 卡号
     */
    private String cardNo;

    /**
     * 卡密
     */
    private String cardSecret;

}
