package cn.com.duiba.live.clue.service.api.remoteservice.third.bank.cardapply;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.third.bank.cardapply.BankCardApplyOrderDto;
import cn.com.duiba.live.clue.service.api.param.third.bank.cardapply.BankCardApplyOrderSearchParam;

import java.util.List;

/**
 * 银行申请卡订单rpc服务
 *
 * @author ouyang
 * @date 2022/8/31 7:06 下午
 **/
@AdvancedFeignClient
public interface RemoteBankCardApplyOrderApiService {

    /**
     * 新增
     *
     * @param dto 订单
     * @return 新增结果
     */
    int insert(BankCardApplyOrderDto dto);

    /**
     * 批量新增
     *
     * @param dtoList 订单列表
     * @return 新增结果
     */
    int batchInsert(List<BankCardApplyOrderDto> dtoList);

    /**
     * 更新
     *
     * @param dto 订单
     * @return 执行结果
     */
    int update(BankCardApplyOrderDto dto);

    /**
     * 获取分页总数 (管理后台)
     * @param param 查询参数（直播用户Id、直播Id、公司Id、活动Id）
     * @return 总记录数
     */
    Long selectCountBySearch(BankCardApplyOrderSearchParam param);

    /**
     * 获取分页列表 (管理后台)
     * @param param 查询参数（直播用户Id、直播Id、公司Id、活动Id）
     * @return 列表
     */
    List<BankCardApplyOrderDto> selectPageBySearch(BankCardApplyOrderSearchParam param);

    /**
     * 根据主键查询订单记录
     * @param id 订单Id
     * @return 订单记录
     */
    BankCardApplyOrderDto selectById(Long id);

    /**
     * 根据订单号查询数据
     * @param orderNum 订单号
     * @return 影响行数
     */
    BankCardApplyOrderDto findByOrderNum(String orderNum);


}
