package cn.com.duiba.live.clue.service.api.dto.third.bank.cardhold;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author ouyang
 * @date 2022/8/17 11:30 上午
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class LiveCardHolderDto implements Serializable {

    private static final long serialVersionUID = 3328899458797136110L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 持卡类型
     * @see cn.com.duiba.live.clue.service.api.enums.third.bank.cardhold.CardHolderTypeEnum
     */
    private Integer cardHolderType;

    /**
     * 手机号
     */
    private String phoneNum;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 持卡状态 1:已持卡 2:未持卡
     * @see cn.com.duiba.live.clue.service.api.enums.third.bank.cardhold.CardHolderStatusEnum
     */
    private Integer cardHolderStatus;
}
