/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.live.clue.service.api.enums.mall.order;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum MallOrderBizTypeEnum {
    LIVE(1, "\u76f4\u64ad\u573a\u666f"),
    BANK_APPLY_ACTIVITY(2, "\u94f6\u884c\u529e\u5361\u6d3b\u52a8\u573a\u666f"),
    LIVE_ACTIVITY(3, "\u76f4\u64ad\u6d3b\u52a8"),
    COMPANY_HOME(4, "\u516c\u53f8\u4e3b\u9875\u5546\u54c1"),
    LIVE_NEWCOMERS(5, "\u76f4\u64ad\u4e2d-\u65b0\u4eba\u4e13\u4eab");

    private final Integer code;
    private final String desc;
    private static final Set<Integer> LIVE_TYPES;
    private static final Map<Integer, MallOrderBizTypeEnum> ENUM_MAP;

    public static boolean isLiveOrder(Integer type) {
        if (type == null) {
            return false;
        }
        return LIVE_TYPES.contains(type);
    }

    public static MallOrderBizTypeEnum getByType(Integer type) {
        if (type == null) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    private MallOrderBizTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    static {
        LIVE_TYPES = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{LIVE.getCode(), LIVE_ACTIVITY.getCode(), LIVE_NEWCOMERS.getCode()}));
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(MallOrderBizTypeEnum.values()).collect(Collectors.toMap(MallOrderBizTypeEnum::getCode, Function.identity(), (v1, v2) -> v2)));
    }
}

