package cn.com.duiba.live.clue.service.api.dto.mall.group;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 拼团记录
 *
 * @author kjj mybatis generator
 * 2023-05-10
 */
@Data
public class MallGroupRecordDto implements Serializable {
    private static final long serialVersionUID = 16836899871226478L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 售卖商品id tb_mall_sale_spu.id
     */
    private Long spuId;

    /**
     * 拼团用户id链路，逗号分割
     * max length = 1024
     */
    private String liveUserIds;

    /**
     * 拼团进度 1-未成团 2-已成团 3-拼团失败(拼团时间到) 4-拼团解散（取消订单）
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.group.GroupStatusEnum}
     */
    private Integer groupStatus;

    /**
     * 需拼团人数
     */
    private Integer groupNum;

    /**
     * 拼团周期 单位/h
     */
    private Integer groupPeriod;

    /**
     * 拼团限制
     */
    private Integer groupLimit;

    /**
     * 已参团人数，下单后记录
     */
    private Integer joinedNum;

    /**
     * 拼团过期时间
     */
    private Date expireTime;
}