package cn.com.duiba.live.clue.service.api.enums.clue;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 直播互动类型枚举
 * @author 吴文哲
 * @date 2020-04-02 15:07
 **/
@Getter
@AllArgsConstructor
public enum LiveInteractTypeEnum {

    MATERIAL(1,"图文资料"),
    QUESTION(2,"问题"),
    SUBSCRIBE(3,"关注直播间"),
    ACCUMULATE_READ(4,"累计观看"),
    FRIEND_INVITE(5,"邀请好友"),
    FREE_GET(6,"免费领"),
    GRAB_WELFARE(7,"抢权益"),
    CHOICE(8,"测一测"),
    LINK_RESOURCE(9,"链接资料"),
    OA_RESOURCE(10,"公众号资料"),
    FREE_RESOURCE(11, "免费领资料"),
    FORM_RESOURCE(12, "表单资料"),
    TEST_RESOURCE(13,"测试资料"),
    GAME_RESOURCE(14,"小游戏资料"),
    QUES_REWARD(15, "答题领奖"),
    FISSION_TREASURE_AWARD(16, "裂变宝箱奖品"),
    TIME_TREASURE_AWARD(17, "停留时长宝箱奖品"),
    TIMED_CHOICE(18, "推送定时投票"),
    TREASURE_TEAM_AWARD(19, "宝箱-团队奖励"),
    BUY_INSURANCE_AWARD(20, "直播中购买保险-奖励"),
    LIVE_SURVEY_AWARD(21, "直播中提交问卷-奖励"),
    LIVE_SECOND_KILL_GOODS(22, "秒杀商品"),
    EVALUATION_RESOURCE(23, "测评资料"),
    GOLDEN_EGG_TREASURE_AWARD(24, "砸金蛋宝箱奖品"),
    LIVE_SURVEY_REWARD(25, "直播问券有奖"),
    MALL_SALE_GOODS(26, "直播商城售卖商品"),
    MALL_LIVING_LOTTERY(27, "直播中抽奖-商城版"),
    MALL_FISSION_TREASURE_AWARD(28, "裂变宝箱-商城版"),
    MALL_TIME_TREASURE_AWARD(29, "时长宝箱-商城版"),
    MALL_FREE_GET(30, "免费领-商城版"),
    MALL_GOLDEN_EGG_TREASURE_AWARD(31, "砸金蛋-商城版"),
    MALL_QUES_REWARD(32, "有奖答题-商城版"),
    MALL_LIVE_SURVEY_AWARD(33, "问卷有奖-商城版"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
}
