package cn.com.duiba.live.clue.service.api.dto.mall.address;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商城 - 用户收货地址
 *
 * @author kjj mybatis generator
 * 2022-08-09
 */
@Data
public class MallUserAddressDto implements Serializable {

    private static final long serialVersionUID = -2617024735407819119L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 用户地址类型
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.address.MallAddressBizType}
     */
    private Integer bizType;

    /**
     * 收货人姓名
     * max length = 20
     */
    private String receiverName;

    /**
     * 收货人手机号
     * max length = 20
     */
    private String phoneNum;

    /**
     * 行政区划
     * max length = 50
     */
    private String adNames;

    /**
     * 具体地址
     * max length = 100
     */
    private String detailInfo;

    /**
     * 是否是默认地址
     * {@link cn.com.duiba.kjy.base.api.enums.BooleanEnum}
     */
    private Integer defaultAddress;

    /**
     * 是否删除
     * {@link cn.com.duiba.kjy.base.api.enums.BooleanEnum}
     */
    private Integer deleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

}