package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 售后单详情Dto
 *
 * @author xuzhigang
 * @date 2022/8/17 7:33 下午
 **/
@Data
public class MallAfterSaleOrderListDto implements Serializable {

    private static final long serialVersionUID = -8109626347912434718L;

    // -------- 售后单信息 --------

    /**
     * 售后订单id
     */
    private Long id;

    /**
     * 售后单号
     */
    private String afterSaleOrderNo;

    /**
     * 售后类型1-仅退款 2-退货退款
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallAfterSaleTypeEnum}
     */
    private Integer afterSaleType;

    /**
     * 售后状态 一个订单只能有一个成功的售后订单 ( status = 已退款 )
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallAfterSaleStatusEnum}
     */
    private Integer afterSaleStatus;

    /**
     * 售后原因
     */
    private String afterSaleReason;

    /**
     * 补充描述
     */
    private String additionalDesc;

    /**
     * 申请售后时间
     */
    private Date gmtCreate;

    // -------- 订单信息 --------

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 订单编号
     */
    private String bizOrderNo;

    /**
     * 下单时间
     */
    private Date orderTime;

    /**
     * 购买数量
     */
    private Integer buyNum;

    /**
     * 订单总金额
     */
    private Integer orderAmount;

    /**
     * 订单状态
     */
    private Integer orderStatus;

    /**
     * 物流状态
     */
    private Integer expressState;

    /**
     * 退货地址及联系方式等信息
     */
    private String refundInfo;

    /**
     * 购买方式
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderBuyWayEnum}
     */
    private Integer buyWay;

    // -------- 商品信息 --------

    /**
     * 商品信息
     */
    private MallOrderGoodsSnapDto goodsInfo;

}
