package cn.com.duiba.live.clue.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveRedPacketReceiveDto;
import cn.com.duiba.live.clue.service.api.param.clue.LiveRedPacketReceiveSearchParam;

import java.util.List;

/**
 * 领取记录
 * @author lizhi
 * @date 2020/6/19 1:59 PM
 */
@AdvancedFeignClient
public interface RemoteLiveRedPacketReceiveApiService {

    //====================增删改====================

    /**
     * 批量新增
     * @param list 领取记录集合
     * @return 回填主键后的值
     */
    List<LiveRedPacketReceiveDto> batchInsert(List<LiveRedPacketReceiveDto> list);

    /**
     * 更新
     * @param dto 直播红包领取记录
     * @return 执行结果
     */
    int update(LiveRedPacketReceiveDto dto);

    /**
     * 批量更新
     * @param dtoList 领取记录集合
     * @return 执行结果
     */
    int batchUpdate(List<LiveRedPacketReceiveDto> dtoList);

    //====================查询====================

    /**
     * 根据条件查询，不分页
     * @param param 查询条件
     * @return 直播红包领取记录集合
     */
    List<LiveRedPacketReceiveDto> selectPage(LiveRedPacketReceiveSearchParam param);

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播红包领取记录
     */
    LiveRedPacketReceiveDto selectById(Long id);

    /**
     * 根据主键批量查询
     * @param ids 主键集合
     * @return 领取记录集合
     */
    List<LiveRedPacketReceiveDto> selectByIds(List<Long> ids);

    /**
     * 根据订单号查询领取记录
     * @param bizTradeNo 订单号
     * @return 领取记录
     */
    LiveRedPacketReceiveDto selectByBizTradeNo(String bizTradeNo);

    /**
     * 查询本场直播已领取手气王用户ID集合（计算手气王领取资格时用）
     * @param liveId 直播ID
     * @return 已领取手气王的用户ID集合
     */
    List<Long> selectLuckUserIds(Long liveId);
}
