package cn.com.duiba.live.clue.service.api.param.mall.order;

import cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderAuditStateEnum;
import cn.com.duiba.wolf.utils.NumberUtils;
import lombok.Data;

import javax.print.attribute.standard.NumberUp;
import java.io.Serializable;

@Data
public class MallOrderAuditParam implements Serializable {
    private static final long serialVersionUID = 5223472907469503092L;
    private Long orderId;
    /**
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderAuditStateEnum }
     */
    private Integer auditState;

    /**
     * 订单状态
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallOrderStatusEnum}
     */
    private Integer orderStatus;

    private String reason;

    public Integer getOrderStatus() {
        if (orderStatus != null && this.orderStatus > 0) {
            return this.orderStatus;
        }
        MallOrderAuditStateEnum state = MallOrderAuditStateEnum.getByState(this.getAuditState());
        return state != null ? state.getOrderState().getCode() : null;
    }
}
