package cn.com.duiba.live.clue.service.api.remoteservice.agent;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.agent.LiveAgentInviteCodeDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/9/27 14:27 下午
 * @description 直播客户经理面签码 RPC
 */
@AdvancedFeignClient
public interface RemoteLiveAgentInviteCodeService {

    /**
     * 根据id查询
     *
     * @param id 主键id
     * @return 详情
     */
    LiveAgentInviteCodeDto selectById(Long id);

    /**
     * 根据直播Id、代理人Id查询
     *
     * @param liveId  直播Id
     * @param agentId 代理人Id
     * @return 详情
     */
    LiveAgentInviteCodeDto selectByLiveIdAndAgentId(Long liveId, Long agentId);

    /**
     * 根据直播Id、代理人Id查询
     *
     * @param liveIds 直播Id列表
     * @param agentId 代理人Id
     * @return 详情
     */
    List<LiveAgentInviteCodeDto> listByLiveIdsAndAgentId(List<Long> liveIds, Long agentId);

    /**
     * 根据直播Id、代理人Id查询
     *
     * @param liveId   直播Id
     * @param agentIds 代理人Id列表
     * @return 详情
     */
    List<LiveAgentInviteCodeDto> listByLiveIdAndAgentIds(Long liveId, List<Long> agentIds);

    /**
     * 新增
     *
     * @param dto 代理人面签码配置
     * @return 执行结果
     */
    Long insert(LiveAgentInviteCodeDto dto);

    /**
     * 更新面签码
     *
     * @param dto 代理人面签码配置
     * @return 执行结果
     */
    int updateRes(LiveAgentInviteCodeDto dto);

}