package cn.com.duiba.live.clue.service.api.remoteservice.mall.order;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.mall.order.MallAfterSaleOrderDto;
import cn.com.duiba.live.clue.service.api.dto.mall.order.MallAfterSaleOrderListDto;
import cn.com.duiba.live.clue.service.api.param.mall.order.MallAfterSaleOrderSearchParam;

import java.util.Date;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/08/11 10:44
 * @description 商城 - 售后 RPC
 */
@AdvancedFeignClient
public interface RemoteMallAfterSaleOrderService {

    /**
     * 根据id查询
     *
     * @param id 主键id
     * @return 售后详情
     */
    MallAfterSaleOrderDto selectById(Long id);

    /**
     * 根据ids查询
     *
     * @param ids 主键id列表
     * @return 售后详情
     */
    List<MallAfterSaleOrderDto> listByIds(List<Long> ids);

    /**
     * 根据订单Id查询售后单列表
     *
     * @param orderId 订单id
     * @return 售后详情
     */
    List<MallAfterSaleOrderDto> listByOrderId(Long orderId);

    /**
     * 根据订单Id查询最近一条售后单
     *
     * @param orderId 订单id
     * @return 售后详情
     */
    MallAfterSaleOrderDto findRecentByOrderId(Long orderId);

    /**
     * 新增售后单
     *
     * @param dto 售后详情
     * @return 新增结果
     */
    Long insert(MallAfterSaleOrderDto dto);

    /**
     * 更新物流单号, 同时流转状态
     * 5:等待上传单号 -> 6:等待商家收货
     *
     * @param id         主键
     * @param expressNum 物流单号
     * @return 更新结果
     */
    int updateExpressNum(Long id, String expressNum);

    /**
     * 更新售后单状态
     *
     * @param id        主键
     * @param oldStatus 老状态
     * @param newStatus 新状态
     * @return 执行结果
     */
    int updateStatusById(Long id, Integer oldStatus, Integer newStatus);

    /**
     * 进入「需要用户上传单号」状态，同时更新上传单号截止时间
     * 当售后类型为「退货退款时」调用
     *
     * @param id                  主键
     * @param autoCloseReturnTime 用户上传单号截止时间
     * @return 执行结果
     */
    int updateUserUploadStatusById(Long id, Date autoCloseReturnTime);

    /**
     * 售后单审核拒绝
     * 1. 「待审核」-> 「审核失败」
     * 2. 「商家待收货」 -> 「商家审核拒绝」
     *
     * @param id           主键
     * @param oldStatus    老状态
     * @param newStatus    新状态
     * @param rejectReason 拒绝理由
     * @return 执行结果
     */
    int rejectAfterSale(Long id, Integer oldStatus, Integer newStatus, String rejectReason);

    /**
     * 根据条件,查询记录的总记录数
     *
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    Long selectCount(MallAfterSaleOrderSearchParam param);

    /**
     * 分页查询
     *
     * @param param 查询参数
     * @return 售后订单列表
     */
    List<MallAfterSaleOrderListDto> selectListPage(MallAfterSaleOrderSearchParam param);
}