package cn.com.duiba.live.clue.service.api.remoteservice.clue;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.clue.LiveWinnerLocationDto;

import java.util.List;

/**
 * 直播中奖收货地址信息接口
 * @author xiaotian
 * @date 2021/02/06 3:41 下午
 **/
@AdvancedFeignClient
public interface RemoteLiveWinnerLocationApiService {

    //====================增删改====================
    /**
     * 批量插入
     * @param dtos
     * @return
     */
    int batchInsert(List<LiveWinnerLocationDto> dtos);

    /**
     * 批量更新
     * @param dtos
     * @return
     */
    int batchUpdate(List<LiveWinnerLocationDto> dtos);

    //====================查询====================

    /**
     * 根据直播间id + 访客id查询中奖信息
     * @param liveId 直播间id
     * @param visitorIds 访客id列表
     * @return 直播中奖用户信息
     */
    List<LiveWinnerLocationDto> findByLiveIdAndLiveVisitorIds(Long liveId, List<Long> visitorIds);
}
