package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商城-用户退款订单
 *
 * @author kjj mybatis generator
 * 2022-08-09
 */
@Data
public class MallRefundOrderDto implements Serializable {

    private static final long serialVersionUID = 16600245529016735L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 业务方退款单号
     * max length = 40
     */
    private String bizRefundNo;

    /**
     * 商城订单id tb_mall_order.id
     */
    private Long orderId;

    /**
     * 商城订单编号tb_mall_order.biz_order_no
     * max length = 64
     */
    private String bizOrderNo;

    /**
     * 退款金额
     */
    private Integer refundAmount;

    /**
     * 退款状态 1-初始化状态, 2-第三方退款申请失败, 3-第三方退款申请成功, 4-退款成功 5-退款失败
     * {@link cn.com.duiba.kjy.paycenter.api.enums.RefundOrderStatusEnum}
     */
    private Integer refundStatus;

    /**
     * 退款理由
     * max length = 100
     */
    private String refundReason;

    /**
     * 退款时间
     */
    private Date refundTime;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}