package cn.com.duiba.live.clue.service.api.param.mall.order;

import cn.com.duiba.live.clue.service.api.param.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.List;

/**
 * @author xuzhigang
 * @date 2022/8/17 7:43 下午
 **/
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
public class MallAfterSaleOrderSearchParam extends PageQuery {

    private static final long serialVersionUID = -5044051257429268046L;

    /**
     * 直播用户id
     */
    private Long liveUserId;

    /**
     * 售后状态集合
     * 全部: 不传
     * 待处理: 1、2、5、6
     * 已完成: 3、4、7、8、9
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallAfterSaleStatusEnum}
     */
    private List<Integer> afterSaleStatusList;

    /**
     * 售后类型 1-仅退款 2-退货退款
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.MallAfterSaleTypeEnum}
     */
    private Integer afterSaleType;

    /**
     * 商城订单编号
     * tb_mall_order.biz_order_no
     */
    private String bizOrderNo;

    /**
     * 售后订单号
     */
    private String afterSaleOrderNo;

}
