package cn.com.duiba.live.clue.service.api.remoteservice.conf;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.dto.conf.LiveAgentSpecifyAwardDto;
import cn.com.duiba.live.clue.service.api.param.clue.LiveAgentSpecifyAwardSearchParam;

import java.util.List;

/**
 * 直播代理人指定中奖rpc接口
 * @author 吴文哲
 * @date 2020-09-06 14:31
 **/
@AdvancedFeignClient
public interface RemoteLiveAgentSpecifyAwardApiService {

    /**
     * 新增
     * @param dto 直播配置-代理人指定中奖
     * @return 主键
     */
    Long insert(LiveAgentSpecifyAwardDto dto);

    /**
     * 根据条件查询
     * @param param 查询条件
     * @return 直播配置-代理人指定中奖集合
     */
    List<LiveAgentSpecifyAwardDto> selectList(LiveAgentSpecifyAwardSearchParam param);

    /**
     * 根据条件,查询记录的总记录数
     * @param param 查询条件
     * @return 符合条件的记录数
     */
    int selectCount(LiveAgentSpecifyAwardSearchParam param);

}
