package cn.com.duiba.live.clue.service.api.remoteservice.third.bank.cardapply;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.clue.service.api.bean.third.bank.apply.CmbConfigBean;
import cn.com.duiba.live.clue.service.api.bean.third.bank.apply.HxCreditApplyConfigBean;
import cn.com.duiba.live.clue.service.api.bean.third.bank.apply.JsCreditApplyConfigBean;
import cn.com.duiba.live.clue.service.api.bean.third.bank.apply.NbCreditApplyConfigBean;
import cn.com.duiba.live.clue.service.api.dto.third.bank.cardapply.BankCardApplyOrderDto;
import cn.com.duiba.live.clue.service.api.param.third.bank.cardapply.BankCardApplyOrderSearchParam;
import java.util.List;
import java.util.Map;

/**
 * 银行申请卡订单rpc服务
 *
 * @author ouyang
 * @date 2022/8/31 7:06 下午
 **/
@AdvancedFeignClient
public interface RemoteBankCardApplyOrderApiService {

    /**
     * 新增
     *
     * @param dto 订单
     * @return 新增结果
     */
    int insert(BankCardApplyOrderDto dto);

    /**
     * 批量新增
     *
     * @param dtoList 订单列表
     * @return 新增结果
     */
    int batchInsert(List<BankCardApplyOrderDto> dtoList);

    /**
     * 更新
     *
     * @param dto 订单
     * @return 执行结果
     */
    int update(BankCardApplyOrderDto dto);

    /**
     * 获取分页总数 (管理后台)
     * @param param 查询参数（直播用户Id、直播Id、公司Id、活动Id）
     * @return 总记录数
     */
    Long selectCountBySearch(BankCardApplyOrderSearchParam param);

    /**
     * 获取分页列表 (管理后台)
     * @param param 查询参数（直播用户Id、直播Id、公司Id、活动Id）
     * @return 列表
     */
    List<BankCardApplyOrderDto> selectPageBySearch(BankCardApplyOrderSearchParam param);

    /**
     * 根据主键查询订单记录
     * @param id 订单Id
     * @return 订单记录
     */
    BankCardApplyOrderDto selectById(Long id);

    /**
     * 根据业务单号更新申卡状态
     * @param applyStatus 申卡状态
     * @param orderNum 订单号
     * @return 影响行数
     */
    Boolean updateApplyStatusByOrderNum(Integer applyStatus,String orderNum);

    /**
     * 根据订单号查询数据
     * @param orderNum 订单号
     * @return 影响行数
     */
    BankCardApplyOrderDto findByOrderNum(String orderNum);

    /**
     * 获取用户进件状态
     * @param liveUserId 用户id
     * @param companyId 公司id
     * @param applySource 申请来源(不传查全部)
     * @return 进件状态
     */
    Integer getApplyState(Long liveUserId, Long companyId, String applySource);

    /**
     * 获取用户指定进件状态的记录,仅返回1条
     *
     * @param liveUserId  用户id
     * @param activityId 办卡活动id
     * @param applyStatus 进件状态
     * @return 进件记录
     */
    BankCardApplyOrderDto getValidApplyOrderByUserAndActivity(Long liveUserId, Long activityId, Integer applyStatus);

    /**
     * 招商银行配置
     * @return 配置
     */
    CmbConfigBean getCmbConfigBean();

    /**
     * 华夏银行配置
     * @return 配置
     */
    HxCreditApplyConfigBean getHxCreditApplyConfigBean();

    /**
     * 江苏银行配置
     * @return 配置
     */
    JsCreditApplyConfigBean getJsCreditApplyConfigBean();

    /**
     * 宁波银行配置
     * @return 配置
     */
    NbCreditApplyConfigBean getNbCreditApplyConfigBean();

    /**
     * 所有配置了申卡活动的公司
     * @return 公司ids
     */
    List<Long> getTotalConfigCompanyIds();

    /**
     * 获取用户指定进件成功状态map
     * applyStatus = APPLY_GIFT
     * @param liveUserIds  用户ids
     * @param activityId 办卡活动id
     * @param applyStatus 办卡状态
     * @return 进件记录
     */
    Map<Long, Integer>  getUserApplyStatusMap(List<Long> liveUserIds, Long activityId,Integer applyStatus);


}
