package cn.com.duiba.live.clue.service.api.bean.conf.innerlog;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播事件（红包、抽奖等）时间内部日志
 * @author lizhi
 * @date 2020/10/28 11:53 上午
 */
@Data
public class LiveEventTimeBean implements Serializable {

    private static final long serialVersionUID = -5671118009561118638L;

    /**
     * 直播ID
     */
    @JSONField(name = "live_id")
    private Long liveId;

    /**
     * 事件配置ID，没有传0
     */
    @JSONField(name = "conf_id")
    private Long confId;

    /**
     * 事件类型
     * @see cn.com.duiba.live.clue.service.api.enums.conf.innerlog.LiveEventTypeEnum
     */
    @JSONField(name = "event_type")
    private Integer eventType;

    /**
     * 时间类型
     * @see cn.com.duiba.live.clue.service.api.enums.conf.innerlog.LiveEventTimeTypeEnum
     */
    @JSONField(name = "time_type")
    private Integer timeType;

    /**
     * 具体时间
     */
    @JSONField(format="yyyy-MM-dd HH:mm:ss")
    private Date time;
}
