package cn.com.duiba.live.clue.service.api.bean.conf.mall.coupon;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/09/15 11:50
 * @description 商城 - 优惠券限制规则
 */
@Data
public class MallCouponLimitConfBean implements Serializable {

    private static final long serialVersionUID = 1397166677030804540L;

    /**
     * 适用商品限制标志, 0-通用 1-仅部分商品可用
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum}
     */
    private Integer limitGoodsFlag;

    /**
     * 适用商品列表
     */
    private List<Long> limitGoodsIds;

    /**
     * 叠加规则, 1-不可与其他优惠券叠加使用
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.coupon.limit.CouponOverlayRuleType}
     */
    private Integer overlayRule;

    /**
     * 退回逻辑, 1-未支付订单取消, 优惠券退回;已支付订单退款, 优惠券不退回
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.coupon.limit.CouponReturnRuleType}
     */
    private Integer returnRule;

    /**
     * 领取限制, 每个用户限制领取张数
     */
    private Integer receiveNumLimit;

    /**
     * 领取门槛限制
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.coupon.limit.CouponReceiveThresholdRuleType}
     */
    private Integer receiveThresholdLimit;

}

