package cn.com.duiba.live.clue.service.api.dto.conf.card;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 银行卡链接配置表
 * @author kjj mybatis generator 
 * @date 2022-08-31
 */
@Data
public class BankCardLinkConfDto implements Serializable {
     
    private static final long serialVersionUID = 16619143814862549L;

    /**
     * id
     */
    private Long id;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 银行卡名称
     */
    private String cardName;

    /**
     * 办卡类型,1:信用卡 2:储蓄卡
     * @see cn.com.duiba.live.clue.service.api.enums.conf.bank.card.BankCardTypeEnum
     */
    private Integer cardType;

    /**
     * 办卡链接类型,1:h5 2:小程序
     * @see cn.com.duiba.live.clue.service.api.enums.conf.bank.card.BankCardLinkTypeEnum
     */
    private Integer cardLinkType;

    /**
     * 办卡h5链接地址
     */
    private String cardH5Link;

    /**
     * 办卡小程序id
     */
    private String cardAppletId;

    /**
     * 办卡小程序地址
     */
    private String cardAppletPath;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}