package cn.com.duiba.live.clue.service.api.dto.conf.card;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播裂变翻牌配置表
 * @author kjj mybatis generator 
 * @date 2021-05-24
 */
@Data
public class LiveFlipCardDto implements Serializable {
     
    private static final long serialVersionUID = 16218470854852006L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 红包ID
     */
    private Long redPacketId;

    /**
     * 提现额度
     */
    private Integer withdrawalAmount;

    /**
     * 提现总个数
     */
    private Integer withdrawalNum;

    /**
     * 初始赠送次数
     */
    private Integer initPresentNum;

    /**
     * 邀请赠送次数
     */
    private Integer invitePresentNum;

    /**
     * 提现条件，邀请人数
     */
    private Integer withdrawalCondition;

    /**
     * 活动图
     */
    private String imgUrl;

    /**
     * 第二活动图
     */
    private String secondImgUrl;

    /**
     * 0:关闭,1:开启
     * @see cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum
     */
    private Integer confStatus;

    /**
     * 是否已经开启过,开启过后就不能修改，1开启过
     * @see cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum
     */
    private Integer alreadyOpen;
}