package cn.com.duiba.live.clue.service.api.dto.conf.flip.step;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 翻牌集字配置
 *
 * @author ZhangJun
 * @date 2021/9/8 3:02 下午
 */
@Data
public class LiveFlipWordStepConfDto implements Serializable {

    private static final long serialVersionUID = -3097419898771469567L;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 免费次数
     */
    private Integer freeNum;

    /**
     * 需要助力人数
     */
    private Integer helpNum;

    /**
     * 首邀开关状态，1-开启，2-关闭
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.flip.word.FlipWordFirstInviteStatusEnum}
     */
    private Integer firstInviteStatus;

    /**
     * 配置状态，1=未开启，2=已开启，3=已下架
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.flip.word.FlipWordConfStatusEnum}
     */
    private Integer openStatus;

    /**
     * 阶梯红包集合
     */
    private List<LiveFlipStepRedDto> stepReds;

    /**
     * 标题配图
     */
    private String titleImage;
}
