package cn.com.duiba.live.clue.service.api.dto.conf.goods;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播秒杀商品优惠券
 *
 * @author ZhangJun
 * @date 2021/12/9 1:46 下午
 */
@Data
public class LiveCouponsDto implements Serializable {

    private static final long serialVersionUID = -5197933283380060027L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 秒杀商品配置id
     * tb_live_interact_conf
     */
    private Long goodsConfId;

    /**
     * 券后价，单位：分
     */
    private Integer afterPrice;

    /**
     * 优惠券关联资料配置id
     * tb_live_interact_conf
     */
    private Long resourceConfId;

    /**
     * 领券方式，1-表单，2-测试
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.goods.LiveCouponsReceiveTypeEnum}
     */
    private Integer receiveType;

    /**
     * 逻辑删除标记，0-未删除，1-已删除
     */
    private Integer logicDeleted;

}
