package cn.com.duiba.live.clue.service.api.dto.conf.live;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播信息dto
 * @author liuchao1
 * @version 1.0
 * @date 2020-07-29 15:12
 */
@Data
public class LiveInfoApiDto implements Serializable {

    private static final long serialVersionUID = -779794210299213752L;

    /**
     * 直播id
     */
    private Long id;

    /**
     * 分享文章
     */
    private String shareContent;

    /**
     * 开播时间
     */
    private Date broadcastTime;


    /**
     * 直播状态：1-未开始，2-直播中，3-断网，4-直播结束
     * @see cn.com.duiba.live.clue.service.api.enums.conf.live.LiveStatusApiEnum
     */
    private Integer liveStatus;

    /**
     * 直播标题
     */
    private String title;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 宣传海报
     */
    private String posterUrl;
}
