package cn.com.duiba.live.clue.service.api.dto.conf.livestream;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 阿里云app
 * @author kjj mybatis generator
 * 2020-03-27
 */
@Data
public class LiveAppDto implements Serializable {
    private static final long serialVersionUID = 15852889338224015L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *app名称
     * max length = 50
     * not null default = null
     */
    private String appName;

    /**
     *
     *推流域名
     * max length = 50
     * not null default = null
     */
    private String pushDomain;

    /**
     *
     *拉流域名
     * max length = 50
     * not null default = null
     */
    private String pullDomain;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;

    /**
     * 使用平台。
     * 1： 阿里云
     * 2： 腾讯云
     * {@link cn.com.duiba.kjy.livecenter.api.enums.live.LiveStreamPlatformEnum }
     */
    private Integer platform;
}
