package cn.com.duiba.live.clue.service.api.dto.conf.livestream;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author dugq
 * @date 2020-09-23 16:14
 * @description 直播拉流地址
 */
@Data
public class LivePlayPullStreamDto implements Serializable {

    private static final long serialVersionUID = 43495601130982550L;

    /**
     * 地址
     */
    private String url;

    /**
     * 地址有效期.截止的具体时间
     */
    private Date validity;

    /**
     * 使用平台。
     * 1： 阿里云
     * 2： 腾讯云
     * {@link cn.com.duiba.kjy.livecenter.api.enums.live.LiveStreamPlatformEnum }
     */
    private Integer platform;

    /**
     * 流的app ID
     */
    private Long appId;

}
