package cn.com.duiba.live.clue.service.api.dto.conf.livestream;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 阿里云app录制配置
 * @author kjj mybatis generator 
 * 2020-03-27
 */
@Data
public class TranscribeConfigDto implements Serializable {
    private static final long serialVersionUID = 15852889338252316L;

    /**
     *
     *主键
     * not null default = null
     */
    private Long id;

    /**
     *
     *直播app的ID
     * not null default = null
     */
    private Long appId;

    /**
     *
     *域名
     * max length = 50
     * not null default = null
     */
    private String domainName;

    /**
     *
     *录制回调地址。包含域名的完整URL
     * max length = 255
     * not null default = null
     */
    private String notifyUrl;

    /**
     *
     *录制格式 支持mp4 m3u8（需要定制） flv.
     * max length = 50
     * not null default = mp4
     */
    private String format;

    /**
     *
     *文件地址 可根据阿里云预留的占位符自由组合
     * max length = 255
     * not null default = video/{AppName}/{StreamName}/{Sequence}{EscapedStartTime}{EscapedEndTime}
     */
    private String objectName;

    /**
     *
     *录制周期 单位:秒 超过的截取成多个视频
     * not null default = 3600
     */
    private Integer cycleDuration;

    /**
     *
     *创建时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtCreate;

    /**
     *
     *更新时间
     * not null default = CURRENT_TIMESTAMP
     */
    private Date gmtModified;
}