package cn.com.duiba.live.clue.service.api.dto.conf.mall.salegoods;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商品列表关联表
 * @author kjj mybatis generator 
 * @date 2023-03-07
 */
@Data
public class LiveGoodsListRelatedDto implements Serializable {
     
    private static final long serialVersionUID = 16781613037535824L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务id,根据type值对应不同表的ID,见cn.com.duiba.live.clue.service.api.enums.conf.mall.goods.related.GoodsListRelatedBizTypeEnum#bizIdDesc
     */
    private Long bizId;

    /**
     * 业务类型,1-直播间新人专享,2-公司首页商品
     * @see cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.related.GoodsListRelatedBizTypeEnum
     */
    private Integer bizType;

    /**
     * 商品关联的id,根据type值对应不同表的ID,见cn.com.duiba.live.clue.service.api.enums.conf.mall.goods.related.GoodsListRelatedTypeEnum#relatedIdDesc
     */
    private Long goodsRelatedId;

    /**
     * 商品关联的类型,1-售卖商品,2-外部商品
     * @see cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.related.GoodsListRelatedTypeEnum
     */
    private Integer goodsRelatedType;

    /**
     * 排序值
     */
    private Integer goodsSort;

    /**
     * 逻辑删除 0-未删除 1-已删除
     * @see cn.com.duiba.live.clue.service.api.enums.conf.DeletedEnum
     */
    private Integer logicDeleted;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;

    /**
     * 商品状态 1-可售 2-售罄
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.related.GoodsListRelatedStatusEnum}
     */
    private Integer goodsStatus;
}