package cn.com.duiba.live.clue.service.api.dto.conf.mall.salegoods;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author lizhi
 * @date 2023/3/13 2:30 下午
 */
@Data
public class MalSaleGoodsCommonDto implements Serializable {

    private static final long serialVersionUID = -2354100433886247779L;

    /**
     * 售卖商品id
     */
    private Long spuId;

    /**
     * 商品库商品id tb_mall_goods.id
     */
    private Long goodsId;

    /**
     * 主图地址
     */
    private String mainImgUrl;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品描述
     */
    private String goodsDesc;

    /**
     * 主标签
     */
    private String mainTag;

    /**
     * 副标签
     */
    private List<String> subTag;

    /**
     * 按钮标题
     */
    private String buttonTitle;

    /**
     * sku列表
     */
    private List<MallSaleSkuDto> skuList;

    /**
     * 分期期数
     */
    private Integer installmentsNum;

    /**
     * 配送方式
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.DeliveryWayTypeEnum}
     */
    private Integer deliveryWay;

    /**
     * 拼团配置
     */
    private MallSaleSpuExtDto.GroupConfDto groupConf;

    /**
     * 包邮类型 {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.FreeDeliveryTypeEnum}
     */
    private Integer freeDelivery;

    /**
     * 商品来源 1-国内 2-海外
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.MallGoodsSourceEnum}
     */
    private Integer goodsSource;

    /**
     * 邮费配置
     */
    private List<MallSaleSpuExtDto.DeliveryFeeConfDto> deliveryFeeConfList;
}
