package cn.com.duiba.live.clue.service.api.dto.conf.mall.salegoods;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 商城商品信息
 *
 * @author xuzhigang
 * @date 2022/8/9 4:28 下午
 **/
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class MallGoodsDto extends MalSaleGoodsCommonDto {

    private static final long serialVersionUID = 4322648347365688620L;

    /**
     * 商品配置id
     */
    private Long confId;

    /**
     * 资料id
     */
    private Long resourceId;

    /**
     * 互动配置类型 26表示售卖商品
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.conf.LiveInteractTypeEnum}
     */
    private Integer type;

    /**
     * 排序值
     */
    private Integer sort;

    /**
     * 0-未添加到商品库 2-可售 3-待售 4-售罄
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.conf.InteractStatusEnums}
     */
    private Integer status;

    /**
     * 是否正在讲解中 true-讲解中 false-不在讲解中
     */
    private Boolean explaining;

    /******************************非售卖商品属性*****************************/

    /**
     * 外链
     */
    private String outLink;

    /**
     * 外链类型
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.resource.OutLinkTypeEnum}
     */
    private Integer outLinkType;

    /**
     * 外链appId 外链类型为小程序时需要传
     */
    private String outLinkAppId;

    /**
     * 资料大图
     */
    private String resourceBigImg;

    /**
     * 测评id
     */
    private Long evaluationId;

    /**
     * 资料关联的通用配置id
     */
    private Long resourceConfId;

    /**
     * 外部商品售价
     */
    private Integer discountedPrice;

    /**
     * 外部商品市场价
     */
    private Integer marketPrice;
}
