package cn.com.duiba.live.clue.service.api.dto.conf.mall.salegoods;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 商品扩展表
 * @author kjj mybatis generator 
 * @date 2023-05-08
 */
@Data
public class MallSaleSpuExtDto implements Serializable {
     
    private static final long serialVersionUID = 16835176886961737L;

    /**
     * 主键
     */
    private Long id;

    /**
     * spu_id tb_mall_sale_spu.id
     */
    private Long spuId;

    /**
     * 配置名称
     */
    private String confName;

    /**
     * 配置值
     */
    private Integer confValue;

    /**
     * 拼团配置
     * confName = 1 {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.MallSaleSpuExtEnum}
     */
    @Data
    public static class GroupConfDto implements Serializable {

        private static final long serialVersionUID = 8693370298222470739L;

        /**
         * 拼团启用状态 0-未启用 1-已启用
         * {@link cn.com.duiba.live.clue.service.api.enums.conf.BooleanEnum}
         */
        private Integer groupEnable;

        /**
         * 拼团人数
         */
        private Integer groupNum;

        /**
         * 拼团周期 单位h
         */
        private Integer groupPeriod;

        /**
         * 拼团限制
         * 1-未参与拼团用户可参与
         * 2-全量用户可参与
         * {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.GroupLimitEnum}
         */
        private Integer groupLimit;
    }

    /**
     * 运费配置
     * confName = 2 {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.salegoods.MallSaleSpuExtEnum}
     */
    @Data
    public static class DeliveryFeeConfDto implements Serializable {

        private static final long serialVersionUID = -1872151605385266470L;

        /**
         * 区域编码
         */
        private List<String> regionCodes;

        /**
         * 区域名称
         */
        private List<String> regionNames;

        /**
         * 邮费
         */
        private Integer deliveryFee;
    }
}