package cn.com.duiba.live.clue.service.api.dto.conf.pass;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 闯关答题红包活动配置redis dto
 * @author chentiecheng
 * @date 2021-06-18
 */
@Data
public class LivePassQuesRedConfRedisDto implements Serializable {

    private static final long serialVersionUID = 7227246583214690845L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 0:关闭,1:开启
     * @see cn.com.duiba.live.clue.service.api.enums.conf.pass.LivePassQuesConfStatusEnum
     */
    private Integer confStatus;

    /**
     * 红包状态
     * @see cn.com.duiba.live.clue.service.api.enums.conf.pass.LivePassRedStatusEnum
     */
    private Integer rewardStatus;
    /**
     * 红包上架时间
     */
    private Date redShelfTime;

    /**
     * 瓜分倒计时
     */
    private Integer carveTime;

    /**
     * 红包:tb_live_conf_red_packet.id
     */
    private Long redPacketId;
    /**
     * 红包实际金额
     */
    private Integer amount;
    /**
     * 红包展示金额
     */
    private Integer showAmount;

    /**
     * 问题列表
     */
    private List<LivePassQuesConfRedisDto>  quesList;
}