package cn.com.duiba.live.clue.service.api.dto.conf.potential;

import lombok.Data;

import java.io.Serializable;

/**
 * 客户管理话术模版
 *
 * @author ZhangJun
 * @date 2021/8/19 11:19 上午
 */
@Data
public class LivePotentialDialogueTemplateConfDto implements Serializable {

    private static final long serialVersionUID = 647444302339348848L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 人脉类型，1-一度人脉，0-多度人脉
     * 关联枚举：{@link cn.com.duiba.live.clue.service.api.enums.conf.potential.AgentDirectlyEnum}
     */
    private Integer inviteType;

    /**
     * 代理人欢迎语
     */
    private String agentGreet;

    /**
     * 客户行动承诺
     */
    private String customerActionPromise;

    /**
     * 代理人结束语
     */
    private String agentConclusion;

}
