package cn.com.duiba.live.clue.service.api.dto.conf.red;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 红包已发放金额统计
 * @author lizhi
 * @date 2021/6/22 3:34 下午
 */
@Data
public class LiveRedReceiveNumStatDto implements Serializable {

    private static final long serialVersionUID = 5734259392994410270L;


    /**
     * 每个类型红包，已发放金额
     * key：红包类型，value：已发放金额
     */
    private Map<Integer, Integer> typeReceiveAmountMap;

    /**
     * 每个类型红包，总金额
     * key：红包类型，value：总金额
     */
    private Map<Integer, Integer> typeTotalAmountMap;
}
