package cn.com.duiba.live.clue.service.api.dto.conf.red;

import lombok.Data;

import java.io.Serializable;
import java.util.Map;

/**
 * 红包已使用额度统计
 * @author lizhi
 * @date 2021/6/22 3:34 下午
 */
@Data
public class LiveRedUseQuotaStatDto implements Serializable {

    private static final long serialVersionUID = 5734259392994410270L;

    /**
     * 已使用总额度
     */
    private Integer totalQuota;

    /**
     * 每个类型红包，已使用额度
     * key：红包类型，value：使用额度
     */
    private Map<Integer, Integer> typeQuotaMap;

    /**
     * 每个类型红包，总金额
     * key：红包类型，value：总金额
     */
    private Map<Integer, Integer> typeTotalAmountMap;
}
