package cn.com.duiba.live.clue.service.api.dto.conf.resource;

import lombok.Data;

import java.io.Serializable;

/**
 * 直播测试类型资料库
 * @author kjj mybatis generator 
 * @date 2021-03-01
 */
@Data
public class ResourceTestDto implements Serializable {
     
    private static final long serialVersionUID = 16145834972487119L;

    /**
     * tb_resource表主键ID
     */
    private Long resourceId;

    /**
     * 测试类型：1-增员秒薪
     * @see cn.com.duiba.live.clue.service.api.enums.conf.resource.ResourceTestTypeEnum
     */
    private Integer testType;

    /**
     * 线索类型：1-领取门票 2-发起咨询
     * @see cn.com.duiba.live.clue.service.api.enums.conf.resource.ResourceTestClueTypeEnum
     */
    private Integer clueType;

    /**
     * 公司行业介绍图片,逗号分隔
     */
    private String tradeIntroducePictures;

    /**
     * 悬浮图片
     */
    private String suspendImg;

    /**
     * 主按钮文案
     */
    private String mainButtonTitle;

    /**
     * 营销按钮文案
     */
    private String saleButtonTitle;

    /**
     * 是否删除，1=已删除，0=未删除
     * @see cn.com.duiba.live.clue.service.api.enums.conf.DeletedEnum
     */
    private Integer deleted;

    /**
     * 资源标题
     */
    private String resourceTitle;

    /**
     * 资料图片
     */
    private String resourceImg;

    /**
     * 按钮名称
     */
    private String resourceButtonTitle;
}