package cn.com.duiba.live.clue.service.api.dto.conf.reward;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author zhuenhui
 * @date 2021/08/31 17:47
 * @description 直播代理人邀约奖励 DTO
 */
@Data
public class LiveAgentInviteRewardDto implements Serializable {

    private static final long serialVersionUID = 1684854568213477159L;

    /**
     * 红包配置Id
     */
    private Long redConfId;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 开启状态
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.common.CommonConfigSwitchEnum}
     */
    private Integer openStatus;

    /**
     * 邀请人数
     */
    private Integer inviteNum;

    /**
     * 展示金额
     */
    private Integer showAmount;

    /**
     * 红包类型
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.red.LiveRedSendTypeEnum}
     */
    private Integer redSendType;

    /**
     * 红包个数
     */
    private Integer redNum;

    /**
     * 红包单个金额
     */
    private Integer redAmount;

    /**
     * 红包总额
     */
    private Integer redTotalAmount;

    /**
     * 红包发放时间
     */
    private Date startTime;

}
