package cn.com.duiba.live.clue.service.api.dto.conf.sign;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播增员签到配置表
 * @author kjj mybatis generator 
 * @date 2021-03-28
 */
@Data
public class LiveIncrStaffSignConfigDto implements Serializable {
     
    private static final long serialVersionUID = 16168622924858065L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播Id
     */
    private Long liveId;

    /**
     * 标题
     */
    private String signInTitle;

    /**
     * 签到小程序二维码
     */
    private String mpQrcodeUrl;

    /**
     * 是否包含问卷 1：不包含、2：包含
     * @see cn.com.duiba.live.clue.service.api.enums.conf.sign.SignSurveyTypeEnum
     */
    private Integer surveyType;

    /**
     * 问券Id
     */
    private Long surveyId;

    /**
     * 问券地址
     */
    private String surveyUrl;

    /**
     * 扫码设置
     *
     * @see cn.com.duiba.live.clue.service.api.enums.conf.sign.SignScanTypeEnum
     */
    private Integer scanType;
    
    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}