package cn.com.duiba.live.clue.service.api.dto.conf.survey.reward;

import cn.com.duiba.live.clue.service.api.enums.conf.conf.InteractStatusEnums;
import lombok.Data;

import java.io.Serializable;

/**
 * 直播问卷有奖配置信息
 * @author lizhi
 * @date 2021/12/14 10:23 上午
 */
@Data
public class LiveSurveyRewardDto implements Serializable {

    private static final long serialVersionUID = -2010628109163118464L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 互动配置ID，tb_live_interact_conf.id
     */
    private Long confId;

    /**
     * 问卷链接
     */
    private String surveyUrl;

    /**
     * 问卷ID
     */
    private Long surveyId;

    /**
     * 奖品ID，tb_welfare.id
     */
    private Long welfareId;

    /**
     * 奖品份数
     */
    private Integer interactNum;

    /**
     * 互动状态，1-未启用，2-已上架，3-已下架
     * @see cn.com.duiba.live.clue.service.api.enums.conf.conf.InteractStatusEnums
     */
    private Integer interactStatus;

    /**
     * 互动类型
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.conf.LiveInteractTypeEnum}
     */
    private Integer interactType;

    public boolean isOpen() {
        return InteractStatusEnums.IN_USE.getStatus().equals(interactStatus);
    }
}
