package cn.com.duiba.live.clue.service.api.dto.conf.treasure.redis;

import lombok.Data;

import java.io.Serializable;

/**
 * redis 宝箱关联配置
 *
 * @author 吴文哲
 * @date 2021/4/20 11:50 上午
 **/
@Data
public class TreasureRelatedRedisDto implements Serializable {

    private static final long serialVersionUID = -8317974628635469709L;

    /**
     * 主键 tb_live_treasure_conf_related.id
     */
    private Long id;

    /**
     * 发放抽奖码数量类型 1:固定数量, 2:随机数量
     *
     * @see cn.com.duiba.live.clue.service.api.enums.conf.treasure.TreasureCodeRuleTypeEnum
     */
    private Integer ruleType;

    /**
     * 业务方ID
     */
    private Long bizConfId;

    /**
     * 宝箱类型 1:抽奖码 2:现金红包 3:实物奖品
     *
     * @see cn.com.duiba.live.clue.service.api.enums.conf.treasure.TreasureTypeEnums
     */
    private Integer treasureType;

    /**
     * 概率 万分制
     */
    private Integer treasureProbability;

}
