package cn.com.duiba.live.clue.service.api.dto.mall.coupon.user;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商城-用户优惠券
 *
 * @author kjj mybatis generator
 * 2022-09-14
 */
@Data
public class MallUserCouponDto implements Serializable {
    private static final long serialVersionUID = 16631472925047720L;

    /**
     * 主键
     */
    private Long id;
    /**
     * 业务id 1-直播id
     */
    private Long bizId;

    /**
     * 场景类型 1-直播
     * {@link cn.com.duiba.live.clue.service.api.enums.conf.mall.coupon.MallCouponBizType}
     */
    private Integer bizType;

    /**
     * 优惠券id, tb_mall_coupon.id
     */
    private Long couponId;

    /**
     * 用户id, tb_live_user.id
     */
    private Long liveUserId;

    /**
     * 优惠券状态
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.coupon.MallUserCouponStatusEum}
     */
    private Integer couponStatus;

    /**
     * 领取时间
     */
    private Date receiveTime;

    /**
     * 使用时间
     */
    private Date useTime;

    /**
     * 发放类型：1-手动领取 2-自动发放
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.coupon.MallUserCouponReceiveTypeEum}
     */
    private Integer receiveType;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}