package cn.com.duiba.live.clue.service.api.dto.mall.coupon.user;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

@Setter
@Getter
@ToString
public class MallUserUsingCouponDto implements Serializable {
    private static final long serialVersionUID = -7199982779356040498L;

    /**
     * 优惠券id, tb_mall_coupon.id
     */
    private Long couponId;

    /**
     * 用户id, tb_live_user.id
     */
    private Long liveUserId;

    /**
     * 使用时间
     */
    private Date useTime;

    public static MallUserUsingCouponDto build(Long couponId,Long liveUserId){
        MallUserUsingCouponDto mallUserUsingCouponDto = new MallUserUsingCouponDto();
        mallUserUsingCouponDto.setCouponId(couponId);
        mallUserUsingCouponDto.setLiveUserId(liveUserId);
        return mallUserUsingCouponDto;
    }

    public static MallUserUsingCouponDto build(Long couponId,Long liveUserId,Date time){
        MallUserUsingCouponDto mallUserUsingCouponDto = new MallUserUsingCouponDto();
        mallUserUsingCouponDto.setCouponId(couponId);
        mallUserUsingCouponDto.setLiveUserId(liveUserId);
        mallUserUsingCouponDto.setUseTime(time);
        return mallUserUsingCouponDto;
    }
}
