package cn.com.duiba.live.clue.service.api.dto.mall.group;

import java.io.Serializable;
import java.util.Date;

import lombok.Data;

/**
 * 拼团明细，下单成功后记录
 *
 * @author kjj mybatis generator
 * 2023-05-10
 */
@Data
public class MallGroupRecordDetailDto implements Serializable {
    private static final long serialVersionUID = 16836900278747592L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 拼团记录id tb_mall_group_record.id
     */
    private Long groupRecordId;

    /**
     * 拼团成员用户id
     */
    private Long liveUserId;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 发起人标志 0-非发起人 1-发起人
     */
    private Integer firstFlag;

    /**
     * 商品id
     */
    private Long spuId;

    /**
     * sku_id
     */
    private Long skuId;

    /**
     * 参与拼团状态 1-已下单 锁定资格 2-已参与 3-已取消
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.group.JoinGroupStatusEnum}
     */
    private Integer joinGroupStatus;

    /**
     * 拼团价
     */
    private Integer groupPrice;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}