package cn.com.duiba.live.clue.service.api.dto.mall.order;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 订单商品快照
 *
 * @author xuzhigang
 * @date 2022/8/16 10:39 下午
 **/
@Data
public class MallOrderGoodsSnapDto implements Serializable {
    private static final long serialVersionUID = 8125872912766028876L;

    /**
     * 商品配置id
     */
    private Long confId;

    /**
     * 商品库商品id
     */
    private Long goodsId;

    /**
     * 商品id
     */
    private Long spuId;

    /**
     * skuId
     */
    private Long skuId;

    /**
     * 商品类型 1-实物 2-虚拟
     */
    private Integer goodsType;

    /**
     * 商品名称
     */
    private String goodsName;

    /**
     * 商品图片
     */
    private String goodsImg;
    /**
     * 商品规格图片(sku图片)
     */
    private String specsImg;

    /**
     * 副标签
     */
    private List<String> subTag;

    /**
     * 售价
     */
    private Integer discountedPrice;

    /**
     * 商品规格
     */
    private String goodsAttribute;

    /**
     * 商品限制区域
     */
    private String limitRegionName;

    /**
     * 商品地区限制类型 1-不限制地区 2-限制指定地区可够买 3-限制指定地区不可购买
     */
    private Integer limitRegionType;

    /**
     * 购买数量限制
     */
    private Integer maxBuyNum;

    /**
     * 支持的支付方式
     * {@link cn.com.duiba.live.clue.service.api.enums.mall.order.PayChannelEnum}
     */
    private List<Integer> payChannels;

    /**
     * 限制银行编码
     */
    private List<String> restrictedBankCodes;

    /**
     * 持卡判断限制
     * 1-不限制 2-仅持卡人购买 3-仅非持卡人购买
     */
    private Integer cardHoldLimit;

    /**
     * 是否需要发货审核0-不需要 1-需要
     */
    private Integer deliveryAudit;

    /**
     * 拼团价
     */
    private Integer groupPrice;

    /**
     * 包邮配置 1-包邮 2-部分地区不包邮
     */
    private Integer freeDelivery;

    /**
     * 商品来源 1-国内 2-海外
     */
    private Integer goodsSource;

    /**
     * 运费配置
     */
    private List<DeliveryFeeConfDto> deliveryFeeConfList;

    /**
     * 运费配置
     */
    @Data
    public static class DeliveryFeeConfDto implements Serializable {

        private static final long serialVersionUID = -1872151605385266470L;

        /**
         * 区域编码
         */
        private List<String> regionCodes;

        /**
         * 区域名称
         */
        private List<String> regionNames;

        /**
         * 邮费
         */
        private Integer deliveryFee;
    }
}
