package cn.com.duiba.live.clue.service.api.enums.conf.agentConf;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * 代理人资料配置开关枚举
 */
@Getter
@AllArgsConstructor
public enum AgentConfOpenFlagEnum {

    /**
     * 开启配置
     */
    AGENT_CONF_CLOSE(0, "配置关闭"),

    /**
     * 关闭配置
     */
    AGENT_CONF_OPEN(1, "配置开启"),
    ;

    /**
     * 配置开启标识，0关闭，1开启
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String des;

    private static final List<Integer> CODES = new ArrayList<>();

    static {
        for (AgentConfOpenFlagEnum item : AgentConfOpenFlagEnum.values()) {
            CODES.add(item.getCode());
        }
    }

    /**
     * 判断枚举值是否合法
     */
    public static boolean containsCode(Integer code) {
        return CODES.contains(code);
    }

}
