package cn.com.duiba.live.clue.service.api.enums.conf.agentConf;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.ArrayList;
import java.util.List;

/**
 * 代理人资料配置地址类型枚举
 */
@Getter
@AllArgsConstructor
public enum AgentConfUrlTypeEnum {

    /**
     * 系统默认类型
     */
    SYSTEM_DEFAULT_TYPE(0, "系统默认类型"),

    /**
     * 自定义类型
     */
    CUSTOM_TYPE(1, "自定义类型"),
    ;

    /**
     * 链接类型
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String des;

    private static final List<Integer> CODES = new ArrayList<>();

    static {
        for (AgentConfUrlTypeEnum item : AgentConfUrlTypeEnum.values()) {
            CODES.add(item.getCode());
        }
    }

    /**
     * 判断枚举之是否合法
     */
    public static boolean containsCode(Integer code) {
        return CODES.contains(code);
    }

}
