package cn.com.duiba.live.clue.service.api.enums.conf.common;

import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author guoxuebiao
 * @date 2021/6/1 4:34 下午
 */
@Getter
public enum CommonConfigSwitchEnum {

    /**
     * 关闭
     */
    CLOSE(0, "关闭"),
    /**
     * 开启
     */
    OPEN(1, "开启")
    ;

    private final Integer type;

    private final String message;

    private static final Map<Integer, CommonConfigSwitchEnum> SWITCH_ENUM_MAP;

    CommonConfigSwitchEnum(Integer type, String message) {
        this.type = type;
        this.message = message;
    }

    static {
        SWITCH_ENUM_MAP = Arrays.stream(CommonConfigSwitchEnum.values()).collect(Collectors.toMap(CommonConfigSwitchEnum::getType, Function.identity(), (v1, v2) -> v2));
    }

    public static CommonConfigSwitchEnum getByType(Integer type) {
        CommonConfigSwitchEnum switchEnum = SWITCH_ENUM_MAP.get(type);
        if (Objects.isNull(switchEnum)) {
            return CLOSE;
        }
        return switchEnum;
    }
}
