package cn.com.duiba.live.clue.service.api.enums.conf.conf;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 公司准客户功能开关配置
 *
 * @author ZhangJun
 * @date 2021/8/10 3:49 下午
 */
@AllArgsConstructor
@Getter
public enum LiveCompanyPotentialSwitchEnum {

    /**
     * 关闭准客户功能
     */
    CLOSE("0", "关闭"),

    /**
     * 开启准客户功能
     */
    OPEN("1", "开启"),
    ;

    /**
     * 开关状态值
     */
    private final String status;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<String, LiveCompanyPotentialSwitchEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(LiveCompanyPotentialSwitchEnum::getStatus, Function.identity())));

    /**
     * 是否存在该枚举key
     *
     * @param key 枚举key
     * @return true=存在，false=不存在
     */
    public static boolean containsKey(String key) {
        if (Objects.isNull(key)) {
            return false;
        }

        LiveCompanyPotentialSwitchEnum item = ENUM_MAP.get(key);
        return Objects.nonNull(item);
    }

}
