package cn.com.duiba.live.clue.service.api.enums.conf.conf;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 关注直播间用户是否推送信息
 *
 * @author HanYaLun
 * @create 2021-11-08
 */
@AllArgsConstructor
@Getter
public enum LiveFollowPushStateEnum {


    /**
     * 关注直播用户不推送
     */
    CLOSE(0, "关注直播用户不推送"),

    /**
     * 关注直播用户推送信息
     */
    OPEN(1, "关注直播用户推送信息");

    /**
     * 码值
     */
    private Integer code;

    /**
     * 描述信息
     */
    private String desc;
}
