package cn.com.duiba.live.clue.service.api.enums.conf.conf.live;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 直播所属主体
 * @author lizhi
 * @date 2023/2/21 1:35 下午
 */
@Slf4j
@AllArgsConstructor
@Getter
public enum LiveContractSubjectEnum {
    DUI_BA(1, "杭州兑吧网络科技有限公司"),
    DUI_A(2, "杭州兑啊网络科技有限公司"),
    KJJ(3, "杭州客吉吉网络科技有限公司"),
    ;

    /**
     * 主体
     */
    private final Integer subject;

    /**
     * 主体名称
     */
    private final String name;

    private static final Map<Integer, LiveContractSubjectEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(LiveContractSubjectEnum::getSubject, Function.identity(), (v1, v2) -> {
        log.error("LiveContractSubjectEnum, distinct, subject={}", v2.getSubject());
        return v2;
    })));

    /**
     * 根据主体类型，获取枚举
     * @param subject 主体类型
     * @return 枚举
     */
    public static LiveContractSubjectEnum getBySubject(Integer subject) {
        if (subject == null) {
            return null;
        }
        return ENUM_MAP.get(subject);
    }

}
